package com.jonohennessy {
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	
	public class ContactView extends MovieClip {
		
		// Declare vars - note automatically declare stage instances is disabled
		public var home_btn:SimpleButton;
		public var info_btn:SimpleButton;
		public var jono_btn:SimpleButton;
		public var louise_btn:SimpleButton;
		public var nz_btn:SimpleButton;
		public var usa_btn:SimpleButton;
		public var nl_btn:SimpleButton;
		private var hennessyModel:HennessyModel;
		private var hennessyController:HennessyController;

		public function ContactView() {
			trace("Contact added");
		}
		
		private function introComplete():void {
			// Disable the animating lock
			hennessyController = HennessyController(root);
			hennessyModel = hennessyController.getModel();
			hennessyModel.setAnimatingLock(false);
		}
		
		private function clickListener(e:MouseEvent):void {
			trace("contact clicked, target: " + e.target.name);
			
			// If allowed to respond
			if (!hennessyModel.getAnimatingLock()) {
			
				//hennessyModel.setMode(HennessyModel.CONTENT_MENU);
				
				// Lock due to animation
				hennessyModel.setAnimatingLock(true);
				
				// Tell the menu
				hennessyController.homeClicked();
			}
		}
		
		private function linkHandler(e:MouseEvent):void {
			var link:String;
			
			switch (e.target) {
				case info_btn:
					link = "mailto:info@jonohennessy.com";
					break;
				case jono_btn:
					link = "mailto:jono@jonohennessy.com";
					break;
				case louise_btn:
					link = "mailto:louise@jonohennessy.com";
					break;
				case nz_btn:
					link = "mailto:mark@phoenixeyewear.co.nz";
					break;
				case usa_btn:
					link = "mailto:reflecteyes@aol.com";
					break;
				case nl_btn:
					link = "mailto:callaieyewear@hetnet.nl";
					break;
			}
			
			trace("Email link: " + link);
			navigateToURL(new URLRequest(link), "_self");
		}
		
		// There is a dispose function, on the timeline, to eliminate the click listener
	}
}